#ifndef __UTILS_H_
#define __UTILS_H_

#define _CRT_SECURE_NO_DEPRECATE

#include <pcap.h>
#include <iostream>
using namespace std;

#ifndef ETH_ALEN
#define ETH_ALEN 6
#endif
#ifndef IP_ALEN
#define IP_ALEN 4
#endif

void printIPAddress(u_int address);
void printIPAddress(const u_char *address);
void printMACAddress(const u_char *address);


/* convert IP addr from string xxx.xxx.xxx.xxx to int */
u_int IP_str2int(const char *address);

/* convert IP addr from char array to int */
u_int IP_ch2int(const u_char *address);

/* convert IP addr from string to char array */
void IP_str2ch(const char *address, u_char ipch[IP_ALEN]);

/* Compare 2 char array */
bool Compare(const u_char *val1, const u_char *val2, u_char length);

#endif
